package gov.va.med.mhv.usermgmt.essapi.service.impl;

import gov.va.med.mhv.common.api.cache.CacheHandler;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.enumeration.ErrorEnum;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.transfer.Session;
import gov.va.med.mhv.common.api.util.MHVApiUtility;
import gov.va.med.mhv.common.api.util.MHVEssApiUtility;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.dto.ActivitySearchCriteriaDTO;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.essapi.service.ActivityAuditAPIService;
import gov.va.med.mhv.usermgmt.essapi.transfer.ActHistTO;
import gov.va.med.mhv.usermgmt.essapi.transfer.ActLoginLogoutTO;
import gov.va.med.mhv.usermgmt.essapi.transfer.ActivitiesTO;
import gov.va.med.mhv.usermgmt.essapi.transfer.ActivityTO;
import gov.va.med.mhv.usermgmt.service.AccountActivityLogService;
import gov.va.med.mhv.usermgmt.service.PatientService;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;
import gov.va.med.mhv.usermgmt.util.activity.ActivityHelper;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.ws.rs.core.Response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.ext.MessageContext;

public class ActivityAuditAPIServiceImpl implements ActivityAuditAPIService{
	private static final Log log = LogFactory.getLog(ActivityAuditAPIServiceImpl.class);

	@Resource
	private UserMgmtService userMgmtService;
	
	@Resource
	private PatientService patientservice;
	
	@Resource
	AccountActivityLogService activityLogService;

	@Override
	public Response auditLogin(ActLoginLogoutTO actLoginLogout) {
		
		Session session = CacheHandler.getInstance().getSession();
		UserProfileDTO uf = getUserProfileDTO(session);
		
		try {
			activityLogService.createAccountActivityLog(
										ActivityHelper.createActivityDTO(
										uf.getId(), 
										ActivityActorTypeEnumeration.SYSTEM,
										actLoginLogout.getIsSuccessful(), 
										ActivityTypeEnumeration.LOGIN_LOGOUT, 
										ActivityActionTypeEnumeration.LOGIN, 
										actLoginLogout.getActivityDetails()!= null ?
												actLoginLogout.getActivityDetails():		
											MHVEssApiUtility.makeActivityDetailValue(session.getClientApplication().getName()) 
										)
			);
		} catch (MHVException e) {
			log.error("Exception occured in Activity Track", e);
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e);
		}
		
		return Response.ok("{\"status\":\"success\" }").build();
	}

	@Override
	public Response auditLogout(ActLoginLogoutTO actLoginLogout) {
		Session session = CacheHandler.getInstance().getSession();
		UserProfileDTO uf = getUserProfileDTO(session);
		
		try {
			activityLogService.createAccountActivityLog(
										ActivityHelper.createActivityDTO(
										uf.getId(), 
										ActivityActorTypeEnumeration.SYSTEM,
										actLoginLogout.getIsSuccessful(), 
										ActivityTypeEnumeration.LOGIN_LOGOUT, 
										ActivityActionTypeEnumeration.LOGOUT, 
										actLoginLogout.getActivityDetails()!= null ?
											actLoginLogout.getActivityDetails():		
										MHVEssApiUtility.makeActivityDetailValue(session.getClientApplication().getName())
										)
			);
		} catch (MHVException e) {
			log.error("Exception occured in Activity Track", e);
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e);
		}
		
		return Response.ok("{\"status\":\"success\" }").build();
	}
	
	
	@Override
	public ActivitiesTO auditActHistory(ActHistTO actHistTO) {
		ActivitySearchCriteriaDTO searchActivityCriteria = new ActivitySearchCriteriaDTO();
		
		Session session = CacheHandler.getInstance().getSession();
		UserProfileDTO uf = getUserProfileDTO(session);
		
		Timestamp startDateTS = null;
		Timestamp endDateTS = null;
		startDateTS= MHVApiUtility.converRFC1123PatternTimeStamp(actHistTO.getStartDate());
		endDateTS = MHVApiUtility.converRFC1123PatternTimeStamp(actHistTO.getEndDate());
		if (startDateTS== null || endDateTS==null) {
			MHVEssApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
		}
		if(ActivityActorTypeEnumeration.fromString(actHistTO.getPerformedBy()) == null ) {
			MHVEssApiUtility.throwException(ErrorEnum.INVALID__PERFORMEDBY_141);
		}
		
		searchActivityCriteria.setFromDate(startDateTS);
		searchActivityCriteria.setToDate(endDateTS);
		searchActivityCriteria.setUserName(uf.getUserName());
		searchActivityCriteria.setPerformerType(actHistTO.getPerformedBy());
		
		
		List<ActivityDTO> activities =null;
		try {
			activities = activityLogService.getAccountActvity(searchActivityCriteria);
		} catch (MHVException e) {
			// TODO Auto-generated catch block
			log.error("Exception occured in Activity Track", e);
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e);
		}

		
		ActivitiesTO activitiesTO = new ActivitiesTO();
		List<ActivityTO> activityList = new ArrayList<ActivityTO>();
		for (ActivityDTO activity: activities) {
			ActivityTO actTO = new ActivityTO();
			actTO.setActivityId(activity.getActivityId());
			actTO.setDateTime(MHVApiUtility.convertDateToRFC1123Pattern(new Date(activity.getCompletionTime().getTime())));
			actTO.setPerfromedBy(activity.getPerformerType());
			actTO.setResult(activity.getStatus()? "success": "failure");
			actTO.setActivity(activity.getActivityType());
			actTO.setAction(activity.getAction());
			actTO.setActivityDetails(activity.getDetailValue());
			activityList.add(actTO);
		}
		activitiesTO.setActivityList(activityList);
		
		return activitiesTO;
	}
	
	private UserProfileDTO getUserProfileDTO( Session session) {
		UserProfileDTO uf = null;
		try {
			uf = userMgmtService.getUserProfileById(session.getUserId());
		} catch (MHVException e2) {
			log.error("Exception occured in User Mangement Service Proxy", e2);
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e2);
		}
		return uf;
	}
	
}
